using System;
using System.Collections.Generic;
using System.Text;
using System.EnterpriseServices;

namespace SharedPropLib
{
   public class SharedPropComponent : ServicedComponent
   {
      public SharedPropComponent() { }

      public int GetNextOrderNumber()
      {
         bool groupExists;
         bool propExists;
         int lastOrderNumber;
         PropertyLockMode propLock = PropertyLockMode.SetGet;
         PropertyReleaseMode propRelease = PropertyReleaseMode.Standard;
         SharedPropertyGroupManager spgm = new SharedPropertyGroupManager();
         SharedPropertyGroup spGroup = spgm.CreatePropertyGroup("Orders",
            ref propLock, ref propRelease, out groupExists);
         SharedProperty orderNumber =
            spGroup.CreateProperty("OrderNumber", out propExists);

         if (!propExists)
            orderNumber.Value = 1;

         lastOrderNumber = (int)orderNumber.Value;
         orderNumber.Value = lastOrderNumber + 1;
         return lastOrderNumber;
      }
   }
}
